Rem
Rem $Header: concdemo.sql 09-oct-2004.10:54:57 jxluo Exp $
Rem
Rem concdemo.sql
Rem
Rem Copyright (c) 2004, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      concdemo.sql -  PLSQL Conditional Compilation demo 
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jxluo       10/09/04 - jxluo_add_plsql_precompiler_demo
Rem    jxluo       10/05/04 - Created
Rem

set serveroutput on size 1000000 format wrapped


create or replace PROCEDURE whetstone IS 

   -- This is a straightforward transliteration of the C Whetstone 
   -- benchmark. The original benchmark was modified lightly to make
   -- its I/O a little cleaner and to serve our purposes of understanding
   -- PL/SQL performance. 

   -- The translation principles are
   --
   --   C int's go to PLS_INTEGER.
   --   C float/double goes to MY_DOUBLE.
   --   C array goes to indexed (and initialized with zeros) table.
   --   C file scope variables (which came from Fortran COMMON) go to
   --     outer procedure level variables.
   --   C file static procedure go to inner procedures.
   --   Variables are named the same except that LOOP (a reserved word in
   --     PL/SQL) became loopc.
   --   The timer is a centi-second timer and is converted to seconds once
   --     the interval is known.

   -- The timing for PL/SQL is very heavily dominated by the times for
   -- modules 7 (trig functions) and 11 (other math functions). These are
   -- much slower in PL/SQL (the core libraries?) than they are in C. So
   -- there are two labels (Skip_Trig and Skip_Math) anc corresponding
   -- (commented out) GOTO statements installed. If the GOTO's are 
   -- commented out, this is the original Whetstone. If they are made
   -- active, it becomes a simpler program and is perhaps more indicative
   -- of the ratio of PL/SQL to C for normal PL/SQL programs.
   subtype MY_DOUBLE is 
$if dbms_db_version.ver_le_9 $then
     NUMBER;
$else
     BINARY_DOUBLE;
$end

   ii pls_integer;

   startsec MY_DOUBLE;
   finisec  MY_DOUBLE;
   
   t MY_DOUBLE;
   t1 MY_DOUBLE;
   t2 MY_DOUBLE;
   
   loopc pls_integer; -- Variable was LOOP in original C
   jj    pls_integer;
   j     pls_integer;
   k     pls_integer;
   l     pls_integer;

   x MY_DOUBLE;
   y MY_DOUBLE;
   z MY_DOUBLE;

   n1 pls_integer;
   n2 pls_integer;
   n3 pls_integer;
   n4 pls_integer;
   n5 pls_integer;
   n6 pls_integer;
   n7 pls_integer;
   n8 pls_integer;
   n9 pls_integer;
   n10 pls_integer;
   n11 pls_integer;

   x1 MY_DOUBLE;
   x2 MY_DOUBLE;
   x3 MY_DOUBLE;
   x4 MY_DOUBLE;

   TYPE e1_table IS table OF MY_DOUBLE index BY binary_integer;
   e1 e1_table;

   kips MY_DOUBLE;
   
   PROCEDURE pa(e IN OUT nocopy e1_table) IS
      j pls_integer;
   BEGIN

      j := 0;
      
      <<l10>> 

        e(1) := ( e(1) + e(2) + e(3) - e(4)) * t;
        e(2) := ( e(1) + e(2) - e(3) + e(4)) * t;
        e(3) := ( e(1) - e(2) + e(3) + e(4)) * t;
        e(4) := (-e(1) + e(2) + e(3) + e(4)) / t2;

	j := j + 1;
	IF j < 6 THEN GOTO l10; END IF;

   END pa;

   PROCEDURE p3(x IN MY_DOUBLE, y IN MY_DOUBLE, z OUT nocopy MY_DOUBLE) IS
      x1 MY_DOUBLE;
      y1 MY_DOUBLE;
   BEGIN
      x1 := x;
      y1 := y;
      x1 := t * (x1 + y1);
      y1 := t * (x1 + y1);
      z := (x1 + y1)/t2;
   END p3;

   PROCEDURE p0 IS
   BEGIN
      e1(j) := e1(k);
      e1(k) := e1(l);
      e1(l) := e1(j);
   END p0;

   PROCEDURE pout(n pls_integer,
		  j pls_integer,
		  k pls_integer,
		  x1 MY_DOUBLE,
		  x2 MY_DOUBLE,
		  x3 MY_DOUBLE,
		  x4 MY_DOUBLE) IS
   BEGIN
      dbms_output.put_line(   
	   to_char(n, '99999999')
	|| to_char(j, '99999999')
	|| to_char(k, '99999999')
	|| to_char(x1, '999.9999eeee')
	|| to_char(x2, '999.9999eeee')
	|| to_char(x3, '999.9999eeee')
	|| to_char(x4, '999.9999eeee') );
   END pout;
   

BEGIN

   -- In PL/SQL, must get the array elements created before the test.

   e1(1) := 0;
   e1(2) := 0;
   e1(3) := 0;
   e1(4) := 0;

 <<lcont>>
   
   -- Start benchmark timing here.

   startsec := dbms_utility.get_time/100;  -- Get_Time in centiseconds
 
   -- The actual benchmark starts here.

$if dbms_db_version.ver_le_9 $then
   t := .499975;
   t1 := 0.50025;
   t2 := 2.0;
$else
   t := .499975d;
   t1 := 0.50025d;
   t2 := 2.0d;
$end

$if dbms_db_version.ver_le_9 $then
   loopc := 5;
   ii    := 5;
$else
   loopc := 20;
   ii    := 20;
$end

   jj    := 1;
   
 <<iiloop>>

   N1  := 0;
   N2  := 12 * LOOPc;
   N3  := 14 * LOOPc;
   N4  := 345 * LOOPc;
   N5  := 0;	
   N6  := 210 * LOOPc;
   N7  := 32 * LOOPc;
   N8  := 899 * LOOPc;
   N9  := 616 * LOOPc;
   N10 := 0;
   N11 := 93 * LOOPc;

   -- Module 1: simple identifiers.

$if dbms_db_version.ver_le_9 $then
   x1 :=  1.0;
   x2 := -1.0;
   x3 := -1.0;
   x4 := -1.0;
$else
   x1 :=  1.0d;
   x2 := -1.0d;
   x3 := -1.0d;
   x4 := -1.0d;
$end

   FOR i IN 1 .. n1 LOOP

      x1 := ( x1 + x2 + x3 - x4) * t;
      x2 := ( x1 + x2 - x3 + x4) * t;
      x3 := ( x1 - x2 + x3 + x4) * t;
      x4 := (-x1 + x2 + x3 + x4) * t;

   END LOOP;

   IF jj = ii THEN
      pout(n1, n1, n1, x1, x2, x3, x4);
   END IF;

   -- Module 2: array elements.
     
$if dbms_db_version.ver_le_9 $then
   e1(1) :=  1.0;
   e1(2) := -1.0;
   e1(3) := -1.0;
   e1(4) := -1.0;
$else
   e1(1) :=  1.0d;
   e1(2) := -1.0d;
   e1(3) := -1.0d;
   e1(4) := -1.0d;
$end
   
   FOR i IN 1 .. n2 LOOP

      e1(1) := ( e1(1) + e1(2) + e1(3) - e1(4)) * t;
      e1(2) := ( e1(1) + e1(2) - e1(3) + e1(4)) * t;
      e1(3) := ( e1(1) - e1(2) + e1(3) + e1(4)) * t;
      e1(4) := (-e1(1) + e1(2) + e1(3) + e1(4)) * t;

   END LOOP;

   IF jj = ii THEN
      pout(n2, n3, n2, e1(1), e1(2), e1(3), e1(4));
   END IF; 

   -- Module 3: Array as parameter
   
   FOR i IN 1 .. n3 LOOP
      pa(e1);
   END LOOP;
   
   IF jj = ii THEN
      pout(n3, n2, n2, e1(1), e1(2), e1(3), e1(4));
   END IF;

   -- Module 4: Conditional jumps
   
   j := 1;

   FOR i IN 1 .. n4 LOOP

      IF j = 1 THEN
	 j := 2;
      ELSE
	 j := 3;
      END IF;
      
      IF j > 2 THEN
	 j := 0;
      ELSE
	 j := 1;
      END IF;
      
      IF j < 1 THEN
	 j := 1;
      ELSE
	 j := 0;
      END IF;
      
   END LOOP;
   
   IF jj = ii THEN
      pout(n4, j, j, x1, x2, x3, x4);
   END IF;

   -- Module 5: Intentionally omitted by Whetstone designers
   
   -- Module 6: Integer arithmetic
   
   j := 1;
   k := 2;
   l := 3;
   
   FOR i IN 1 .. n6 LOOP

      j := j * (k - j) * (l - k);
      k := l * k - (l - j) * k;
      l := (l - k) * (k + j);
      e1(l - 1) := j + k + l;
      e1(k - 1) := j * k * l;
      
   END LOOP;
   
   IF jj = ii THEN
      pout(n6, j, k, e1(1), e1(2), e1(3), e1(4));
   END IF;
   
   -- Module 7: Trigonometric functions

   -- goto Skip_Trig;   -- Activate to eliminat trig calls.

$if dbms_db_version.ver_le_9 $then
   x := 0.5;
   y := 0.5;
$else
   x := 0.5d;
   y := 0.5d;
$end
   
   FOR i IN 1 .. n7 LOOP

      x := t * atan(t2*sin(x)*cos(x)/(cos(x+y) + cos(x-y) - 1));
      y := t * atan(t2*sin(y)*cos(y)/(cos(x+y) + cos(x-y) - 1));

   END LOOP;

   IF jj = ii THEN
      pout(n7, j, k, x, x, y, y);
   END IF;

<<Skip_Trig>>

   -- Module 8: Procedure calls
   
$if dbms_db_version.ver_le_9 $then
   x := 1.0;
   y := 1.0;
   z := 1.0;
$else
   x := 1.0d;
   y := 1.0d;
   z := 1.0d;
$end

   FOR i IN 1 .. n8 LOOP
      p3(x, y, z);
   END LOOP;

   IF jj = ii THEN
      pout(n8, j, k, x, y, z, z);
   END IF;
   
   -- Module 9: Array references
   
   j := 1;
   k := 2;
   l := 3;
   
$if dbms_db_version.ver_le_9 $then
   e1(1) := 1.0;
   e1(2) := 2.0;
   e1(3) := 3.0;
$else
   e1(1) := 1.0d;
   e1(2) := 2.0d;
   e1(3) := 3.0d;
$end

   FOR i IN 1 .. n9 LOOP
      p0();
   END LOOP;
   
   IF jj = ii THEN
      pout(n9, j, k, e1(1), e1(1), e1(3), e1(4));
   END IF;

   -- Module 10: Integer arithmetic
   
   j := 2;
   k := 3;
   
   FOR i IN 1 .. n10 LOOP

      j := j + k;
      k := j + k;
      j := k - j;
      k := k - j - j;
      
   END LOOP;

   IF jj = ii THEN
      pout(n10, j, k, x1, x2, x3, x4);
   END IF;

   -- Module 11: Standard functions

   -- goto Skip_Math;  -- Activate to eliminate math calls.
   
$if dbms_db_version.ver_le_9 $then
   x := 0.75;
$else
   x := 0.75d;
$end

   FOR i IN 1 .. n11 LOOP

      x := sqrt(exp(ln(x)/t1)); -- ln is the equivalent of log.
      
   END LOOP;

   IF jj = ii THEN
      pout(n11, j, k, x, x, x, x);
   END IF;

<<Skip_Math>>

   -- This is the end of the major loop.
   
   jj := jj + 1;
   IF jj <= ii THEN GOTO iiloop; END IF;
   
   -- Stop benchmark timing.

   finisec := dbms_utility.get_time/100; -- Get_Time in centiseconds.
   
   dbms_output.put_line('Loops = ' || loopc 
                    || '; Iterations = ' || ii
                    || '; Duration = ' || (finisec - startsec)
                    || ' sec.' );

   kips := (100.0*loopc*ii)/(finisec - startsec);
  

$if dbms_db_version.ver_le_9 $then
   dbms_output.put_line('PL/SQL number Whetstones = ' 
                        || to_char(kips, '99999'));
$else
   dbms_output.put_line('PL/SQL binary_double Whetstones = ' 
                        || to_char(kips, '99999'));
$end

END whetstone;
/
-- inspect the post-processed source text
begin
  dbms_preprocessor.print_post_processed_source
                    ('PROCEDURE', 'scott', 'whetstone');
  exception when others then
    dbms_output.put_line('Exception caught:'||sqlerrm);
end;
/
-- execute the procedure
execute Whetstone;
